from codeable_detectors.evidences import LinkEvidence


class DetectedComponent(object):
    def __init__(self, directory):
        self.directory = directory
        self.evidences = []
        self.identifier = None
        self.name = None
        self.aliases = []
        self.component_types = []
        self.technology_types = []
        self.link_types = []

    # if a link is implied by the component detected, this method returns the corresponding
    # link evidence
    def get_implied_link_evidence(self):
        return LinkEvidence(self.get_all_matches(), link_types=self.link_types,
                            technology_types=self.technology_types)

    def get_all_matches(self):
        matches = []
        for evidence in self.evidences:
            matches.extend(evidence.matches)
        return matches

    def add_types(self, evidence):
        for t in evidence.component_types:
            if t not in self.component_types:
                self.component_types.append(t)
        for t in evidence.technology_types:
            if t not in self.technology_types:
                self.technology_types.append(t)
        for t in evidence.link_types:
            if t not in self.link_types:
                self.link_types.append(t)

    def compute_identifier(self):
        name = self.name
        if name is None or name == "":
            return ""
        # remove all white space and lower cases first letter
        self.identifier = ''.join(name.split())
        # lower the word only if it is not a capitalized word, like REST
        if not self.identifier[1].isupper():
            self.identifier = self.identifier[0].lower() + self.identifier[1:]

    def add_name_and_compute_id_and_aliases(self, name, project):
        self.name = name
        self.compute_identifier()
        self.aliases = [name, self.identifier]
        for env_var in project.env_vars:
            key = env_var.lower()
            value = project.env_vars[env_var].lower()
            if (self.identifier.lower() in key or
                    self.name.lower() in key or
                    self.identifier.lower() in value or
                    self.name.lower() in value):
                self.aliases.append(key)
                self.aliases.append(value)
